@extends('layouts.admin')

@section('title', 'Create Forum Category')

@section('content')
<div class="dashboard-container">
    <div class="dashboard-card dashboard-card-full">
        <div class="dashboard-card-header">
            <h3>Create Forum Category</h3>
        </div>
        <div class="dashboard-card-body">
            <form action="{{ route('admin.forum.categories.store') }}" method="POST">
                @csrf
                
                <div class="form-group">
                    <label for="name">Category Name</label>
                    <input type="text" name="name" id="name" class="form-control @error('name') has-error @enderror" value="{{ old('name') }}" required>
                    @error('name')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                </div>
                
                <div class="form-group">
                    <label for="description">Description</label>
                    <textarea name="description" id="description" class="form-control @error('description') has-error @enderror">{{ old('description') }}</textarea>
                    @error('description')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                </div>
                
                <div class="form-group">
                    <label for="order">Display Order</label>
                    <input type="number" name="order" id="order" class="form-control @error('order') has-error @enderror" value="{{ old('order', 0) }}" min="0" required>
                    @error('order')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                </div>

                {{-- Access Control Section --}}
                <div class="forum-access-control forum-access-control--category">
                    <div class="forum-access-control__header">
                        <h5 class="forum-access-control__title">Access Control Settings</h5>
                    </div>
                    <div class="forum-access-control__body">
                        <div class="forum-access-control__public-toggle">
                            <input type="checkbox" class="form-check-input" id="is_public" name="is_public" 
                                   value="1" {{ old('is_public', true) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_public">
                                <strong>Public Category</strong> (accessible by everyone)
                            </label>
                            <div class="forum-access-control__help-text">
                                If unchecked, only users with required roles/permissions can access
                            </div>
                        </div>
                        
                        <div id="access-controls" class="forum-access-control__restricted" style="{{ old('is_public', true) ? 'display: none;' : '' }}">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="required_roles">Required Roles</label>
                                        <select multiple class="form-control forum-access-control__select @error('required_roles') has-error @enderror" 
                                                id="required_roles" name="required_roles[]" size="5">
                                            @foreach($roles as $role)
                                                <option value="{{ $role->name }}" 
                                                        {{ in_array($role->name, old('required_roles', [])) ? 'selected' : '' }}>
                                                    {{ ucfirst($role->name) }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <div class="forum-access-control__help-text">
                                            Users need at least ONE of these roles (hold Ctrl to select multiple)
                                        </div>
                                        @error('required_roles')
                                            <div class="error-message">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="required_permissions">Required Permissions</label>
                                        <select multiple class="form-control forum-access-control__select @error('required_permissions') has-error @enderror" 
                                                id="required_permissions" name="required_permissions[]" size="5">
                                            @foreach($permissions as $permission)
                                                <option value="{{ $permission->name }}" 
                                                        {{ in_array($permission->name, old('required_permissions', [])) ? 'selected' : '' }}>
                                                    {{ ucfirst(str_replace('-', ' ', $permission->name)) }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <div class="forum-access-control__help-text">
                                            Users need ALL of these permissions
                                        </div>
                                        @error('required_permissions')
                                            <div class="error-message">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="form-check mt-3">
                    <input type="checkbox" name="is_active" id="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}>
                    <label for="is_active">Active</label>
                </div>
                
                <div class="form-group mt-4">
                    <button type="submit" class="btn btn-primary">Create Category</button>
                    <a href="{{ route('admin.forum.categories') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const isPublicCheckbox = document.getElementById('is_public');
    const accessControls = document.getElementById('access-controls');
    
    function toggleAccessControls() {
        if (isPublicCheckbox.checked) {
            accessControls.style.display = 'none';
        } else {
            accessControls.style.display = 'block';
        }
    }
    
    isPublicCheckbox.addEventListener('change', toggleAccessControls);
    toggleAccessControls(); // Initial state
});
</script>
@endsection